
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 15 10:19:22 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HMACFLOW_Acceptance_test_vectors.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  RYS_SYS_TST_HMACFLOW_Acceptance_test_vectors.c       
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for FLOW Acceptance tests                              
 *
 **************************/
 
 
 /***** Include Files ******/
#include "CRYS_ATP_TST_HMACFLOW_Acceptance.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/


/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
/****** **** Public Functions *****/
/******** Private Functions ******/
/*****************************/
/************** External Key Vectors  ********/
/*****************************/


TST_HMACFLOW_TestDataStruct TST_HMACFLOW_Acceptance_TestData[] =
{
        /************/
        /*        FLOW vectors         */
        /************/
        #if TST_USE_FLOW_HMAC_SHA1MODE_DATA
        { 
		{"Acceptance flow test - HMAC/512ByteData/SHA1 "},
			/* input interrupt id */
			0,

			/* output interrupt id */
			1,

			/* if the data in the buffers are in words and not bytes */ 
			0,

			/* number of input buffers */
			4,

			/* flag if  endian order of the input buffers is big */
			0,

			/* number of output buffers */
			0,
			0,
			/* TST_Expected_output_data */
		{
			0x09,0x72,0xC6,0x5F,0x83,0x94,0x6B,0x96,0x6B,0xE6,0xC3,0x7D,0x4D,0x2E,0x91,0xD5,
            0x4E,0x9F,0x25,0x3C
		},
		
		/* TST_Expected_cyclicOperation_data */
		{
		    0xA4,0xA6,0x2E,0xBD,0x36,0x9E,0xBF,0x8F,0xC1,0xF9,0x12,0x45,0x2A,0x3B,0x15,0xD4,
            0xD6,0x04,0x98,0xC4
		},
		/*HMAC TST_key*/
		{0x4a,0x65,0x66,0x65},/* "Jefe"*/
		/*HMAC TST_keySize */
		4*sizeof(DxUint8_t),
		/* TST_Expected_dataSize */
		CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
		CRYS_HASH_SHA1_mode
	},
	#endif
    #if TST_USE_FLOW_HMAC_SHA224MODE_DATA
    { 
    	{"Acceptance flow test - HMAC/512ByteData/SHA224 "},
    		/* input interrupt id */
    		0,

    		/* output interrupt id */
    		1,

    		/* if the data in the buffers are in words and not bytes */ 
    		0,

    		/* number of input buffers */
    		4,

    		/* flag if  endian order of the input buffers is big */
    		0,

    		/* number of output buffers */
    		0,
    		0,
    		/* TST_Expected_output_data */
    	{
    		0x01,0x5A,0xDA,0x11,0xC0,0x62,0xC3,0x76,0xB1,0x2B,0x23,0xD2,0xC4,0x8D,0x86,0x61,
            0xA8,0x54,0xCA,0xC7,0x2B,0xB4,0x7E,0x21,0x2E,0x15,0x95,0x68
    	},
    	
    	/* TST_Expected_cyclicOperation_data */
    	{
    	    0x3B,0xCE,0xAE,0x63,0x1A,0x4E,0xF7,0xA8,0xDC,0x98,0x66,0xE1,0x10,0x78,0xA7,0xA2,
            0xC8,0xF6,0x94,0x9F,0x25,0x74,0x10,0x59,0x13,0xD8,0x79,0x46
    	},
    	/*HMAC TST_key*/
    	{0x4a,0x65,0x66,0x65},/* "Jefe"*/
    	/*HMAC TST_keySize */
    	4*sizeof(DxUint8_t),
    	/* TST_Expected_dataSize */
    	CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
    	CRYS_HASH_SHA224_mode
    },
	#endif
    #if TST_USE_FLOW_HMAC_SHA256MODE_DATA
    { 
    	{"Acceptance flow test - HMAC/512ByteData/SHA256 "},
    		/* input interrupt id */
    		0,

    		/* output interrupt id */
    		1,

    		/* if the data in the buffers are in words and not bytes */ 
    		0,

    		/* number of input buffers */
    		4,

    		/* flag if  endian order of the input buffers is big */
    		0,

    		/* number of output buffers */
    		0,
    		0,
    		/* TST_Expected_output_data */
    	{
    		0xFB,0xA1,0x66,0x34,0x59,0x90,0xE1,0x50,0x8C,0x0C,0x97,0x71,0x7F,0x5B,0x9B,0x6D,
            0xCC,0x61,0x23,0xB2,0x72,0xF1,0x4D,0x00,0x9D,0xC1,0xEA,0x41,0x40,0x7F,0x6D,0xD7
    	},
    	
    	/* TST_Expected_cyclicOperation_data */
    	{
    	    0x47,0x8A,0xA6,0x97,0xE0,0xFF,0xF7,0x45,0x5D,0x31,0xE7,0x41,0x00,0x9B,0xAA,0xD7,
            0x82,0xC8,0x60,0xEC,0xA0,0xCF,0x68,0x1A,0xD0,0xB9,0x29,0x6E,0xF7,0xEA,0x04,0x4E
    	},
    	/*HMAC TST_key*/
    	{0x4a,0x65,0x66,0x65},/* "Jefe"*/
    	/*HMAC TST_keySize */
    	4*sizeof(DxUint8_t),
    	/* TST_Expected_dataSize */
    	CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
    	CRYS_HASH_SHA256_mode
    },
	#endif
    #if TST_USE_FLOW_HMAC_MD5MODE_DATA
    { 
    	{"Acceptance flow test - HMAC/512ByteData/MD5 "},
    		/* input interrupt id */
    		0,

    		/* output interrupt id */
    		1,

    		/* if the data in the buffers are in words and not bytes */ 
    		0,

    		/* number of input buffers */
    		4,

    		/* flag if  endian order of the input buffers is big */
    		0,

    		/* number of output buffers */
    		0,
    		0,
    		/* TST_Expected_output_data */
    	{
    		0x7E,0x7A,0x8A,0x58,0x1D,0x45,0x4A,0x22,0x17,0x1D,0x97,0xB7,0xEB,0xF1,0x6B,0x22
    	},
    	
    	/* TST_Expected_cyclicOperation_data */
    	{
    	    0x28,0x28,0x91,0x12,0xF0,0x36,0x48,0x00,0xDB,0xFB,0xC5,0xD5,0xE4,0xB5,0xFB,0xE1
    	},
    	/*HMAC TST_key*/
    	{0x4a,0x65,0x66,0x65},/* "Jefe"*/
    	/*HMAC TST_keySize */
    	4*sizeof(DxUint8_t),
    	/* TST_Expected_dataSize */
    	CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES*sizeof(DxUint8_t),
    	CRYS_HASH_MD5_mode
    },
	#endif

	
};

const int TST_NumberOf_HMACFLOW_AcceptanceTests      = sizeof(TST_HMACFLOW_Acceptance_TestData)/sizeof(TST_HMACFLOW_Acceptance_TestData[0]);

#endif

